/******/ (() => { // webpackBootstrap
var __webpack_exports__ = {};
/*!******************************************************!*\
  !*** ./resources/js/admin/purchase_notifications.js ***!
  \******************************************************/
(function ($) {
  "use strict";

  $('body').on('click', '.js-submit-form', function () {
    var $this = $(this);
    var $form = $this.closest('form');
    $this.addClass('loadingbar primary').prop('disabled', true);
    $form.trigger('submit');
  });
  $(document).ready(function () {
    var $searchSelect = $('.search-content-select2');
    var path = $searchSelect.attr('data-path');
    $searchSelect.select2({
      placeholder: $searchSelect.attr('data-placeholder'),
      minimumInputLength: 3,
      allowClear: true,
      ajax: {
        url: path,
        dataType: 'json',
        type: "POST",
        quietMillis: 50,
        data: function data(params) {
          return {
            term: params.term,
            option: $searchSelect.attr('data-search-option')
          };
        },
        processResults: function processResults(data) {
          return {
            results: $.map(data, function (item) {
              return {
                text: item.title,
                id: "".concat(item.id, "_").concat(item.type)
              };
            })
          };
        }
      }
    });
  });
})(jQuery);
/******/ })()
;